
Terrain = class()

function Terrain:init(pos,size)
    self.pos = pos
    self.size = size
    local verts = {}
    for x=1,20 do
        table.insert(verts,vec2(pos.x-size.x/2+(size.x/20)*x,pos.y+size.y/2))
    end
    for y=1,20 do
        table.insert(verts,vec2(pos.x+size.x/2,pos.y+size.y/2-(size.y/20)*y))
    end
    for x=1,20 do
        table.insert(verts,vec2(pos.x+size.x/2-(size.x/20)*x,pos.y-size.y/2))
    end
    for y=1,20 do
        table.insert(verts,vec2(pos.x-size.x/2,pos.y-size.y/2+(size.y/20)*y))
    end
    self.verts = verts
    self.m = mesh()
    self.m:setColors(255,255,255,255)
    self.m.vertices = triangulate(verts)
    self.floor = physics.body(POLYGON,table.unpack(verts))
    self.floor.type = STATIC
    
    self.bound = 30
    self.oe = ElapsedTime
end

function Terrain:draw()
    if ElapsedTime > self.oe+0.2 then
        self.oe = ElapsedTime
        if self.t then
            self.m.vertices = triangulate(self.verts)
            self.floor:destroy()
            self.floor = physics.body(POLYGON,table.unpack(self.verts))
            self.floor.type = STATIC
        end
    end
    self.m:draw() 
    local sv = self.verts
    for i=1,#sv do
        sprite(txture,sv[i].x,sv[i].y,5,5)
    end
    pushStyle()
    fill(0,255)
    text(math.floor(1/DeltaTime).."FPS",100,600)
    popStyle()
end

function Terrain:touched(t)
    self.t = true
    if t.state == ENDED then
        self.t = false
    end
    local p,s = self.pos,self.size
    local tp = vec2(t.x,t.y)
    local sp = #self.verts
    for i=1,sp do
        local sv = self.verts[i]
        local svi
        if i > 1 then
            svi = self.verts[i-1]
        else
            svi = self.verts[sp]
        end
        if not sv then return end
        local pass = true
        if sv:dist(tp) < self.bound then
            local dir = (sv-tp):normalize()*5+vec2(t.deltaX,t.deltaY)
            for ii=1,sp do
                if i ~= ii then
                    local tsv = self.verts[ii]
                    if tsv:dist(sv+dir) < self.bound/2 then
                        pass = false
                    end
                end
            end
            --pass = true
            if pass then
                self.verts[i] = self.verts[i] + dir
            end
        end
        if sv:dist(svi) > self.bound*2 and pass then
            local d = (sv+svi)/2
            if d.x > p.x-s.x/2 and d.x < p.x+s.x/2 and d.y > p.y-s.y/2 then
                table.insert(self.verts,i,d)
            else
                table.remove(self.verts,i)
                return
            end
        elseif sv:dist(svi) < self.bound/2 then
            table.remove(self.verts,i)
            return
        end
    end  
end